/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.css;

import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.CommonUtil;
import com.aptana.editor.common.IPartitioningConfiguration;
import com.aptana.editor.common.ISourceViewerConfiguration;
import com.aptana.editor.common.scripting.IContentTypeTranslator;
import com.aptana.editor.common.scripting.QualifiedContentType;
import com.aptana.editor.common.text.SingleTokenScanner;
import com.aptana.editor.common.text.rules.CommentScanner;
import com.aptana.editor.common.text.rules.EmptyCommentRule;
import com.aptana.editor.common.text.rules.ExtendedToken;
import com.aptana.editor.common.text.rules.ISubPartitionScanner;
import com.aptana.editor.common.text.rules.ResumableSingleLineRule;
import com.aptana.editor.common.text.rules.SubPartitionScanner;
import com.aptana.editor.common.text.rules.ThemeingDamagerRepairer;
import com.aptana.editor.css.CSSCodeScannerFlex;
import com.aptana.editor.css.contentassist.CSSContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.source.ISourceViewer;

public class CSSSourceConfiguration
implements IPartitioningConfiguration,
ISourceViewerConfiguration {
    public static final String PREFIX = "__css_";
    public static final String DEFAULT = "__css___dftl_partition_content_type";
    public static final String STRING_SINGLE = "__css_string_single";
    public static final String STRING_DOUBLE = "__css_string_double";
    public static final String MULTILINE_COMMENT = "__css_multiline_comment";
    public static final String[] CONTENT_TYPES = new String[]{"__css___dftl_partition_content_type", "__css_multiline_comment", "__css_string_single", "__css_string_double"};
    private static final String[][] TOP_CONTENT_TYPES = new String[][]{{"com.aptana.contenttype.css"}};
    private IPredicateRule[] partitioningRules = new IPredicateRule[]{new ResumableSingleLineRule("\"", "\"", (IToken)new ExtendedToken(CSSSourceConfiguration.getToken("__css_string_double")), '\\', true), new ResumableSingleLineRule("'", "'", (IToken)new ExtendedToken(CSSSourceConfiguration.getToken("__css_string_single")), '\\', true), new EmptyCommentRule(CSSSourceConfiguration.getToken("__css_multiline_comment")), new MultiLineRule("/*", "*/", CSSSourceConfiguration.getToken("__css_multiline_comment"), '\u0000', true)};
    private static CSSSourceConfiguration instance;

    static {
        if (CommonEditorPlugin.getDefault() != null) {
            IContentTypeTranslator c = CommonEditorPlugin.getDefault().getContentTypeTranslator();
            c.addTranslation(new QualifiedContentType(new String[]{"com.aptana.contenttype.css"}), new QualifiedContentType(new String[]{"source.css"}));
            c.addTranslation(new QualifiedContentType(new String[]{MULTILINE_COMMENT}), new QualifiedContentType(new String[]{"comment.block.css"}));
            c.addTranslation(new QualifiedContentType(new String[]{STRING_DOUBLE}), new QualifiedContentType(new String[]{"string.quoted.single.css"}));
            c.addTranslation(new QualifiedContentType(new String[]{STRING_SINGLE}), new QualifiedContentType(new String[]{"string.quoted.single.css"}));
        }
    }

    public static CSSSourceConfiguration getDefault() {
        if (instance == null) {
            instance = new CSSSourceConfiguration();
        }
        return instance;
    }

    private CSSSourceConfiguration() {
    }

    public String[] getContentTypes() {
        return CONTENT_TYPES;
    }

    public String[][] getTopContentTypes() {
        return TOP_CONTENT_TYPES;
    }

    public IPredicateRule[] getPartitioningRules() {
        return this.partitioningRules;
    }

    public ISubPartitionScanner createSubPartitionScanner() {
        return new SubPartitionScanner(this.partitioningRules, CONTENT_TYPES, CSSSourceConfiguration.getToken(DEFAULT));
    }

    public String getDocumentContentType(String contentType) {
        if (contentType.startsWith(PREFIX)) {
            return "com.aptana.contenttype.css";
        }
        return null;
    }

    public void setupPresentationReconciler(PresentationReconciler reconciler, ISourceViewer sourceViewer) {
        ThemeingDamagerRepairer dr = new ThemeingDamagerRepairer((ITokenScanner)new CSSCodeScannerFlex());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        reconciler.setDamager((IPresentationDamager)dr, DEFAULT);
        reconciler.setRepairer((IPresentationRepairer)dr, DEFAULT);
        dr = new ThemeingDamagerRepairer(this.getCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, MULTILINE_COMMENT);
        reconciler.setRepairer((IPresentationRepairer)dr, MULTILINE_COMMENT);
        dr = new ThemeingDamagerRepairer(this.getStringScanner());
        reconciler.setDamager((IPresentationDamager)dr, STRING_DOUBLE);
        reconciler.setRepairer((IPresentationRepairer)dr, STRING_DOUBLE);
        dr = new ThemeingDamagerRepairer(this.getStringScanner());
        reconciler.setDamager((IPresentationDamager)dr, STRING_SINGLE);
        reconciler.setRepairer((IPresentationRepairer)dr, STRING_SINGLE);
    }

    public IContentAssistProcessor getContentAssistProcessor(AbstractThemeableEditor editor, String contentType) {
        if ("__dftl_partition_content_type".equals(contentType) || DEFAULT.equals(contentType)) {
            return new CSSContentAssistProcessor(editor);
        }
        return null;
    }

    private ITokenScanner getCommentScanner() {
        return new CommentScanner(CSSSourceConfiguration.getToken("comment.block.css"));
    }

    private ITokenScanner getStringScanner() {
        return new SingleTokenScanner(CSSSourceConfiguration.getToken("string.quoted.single.css"));
    }

    private static IToken getToken(String tokenName) {
        return CommonUtil.getToken((String)tokenName);
    }
}

